using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class AquariumSouthAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new AquariumSouthAddonDeed();
			}
		}

		[ Constructable ]
		public AquariumSouthAddon()
		{
			AddComponent( new AddonComponent( 12387 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 12386 ), 0, 1, 0 );
// 			AddonComponent ac = null;
		}

		public AquariumSouthAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class AquariumSouthAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new AquariumSouthAddon();
			}
		}

		[Constructable]
		public AquariumSouthAddonDeed()
		{
			Name = "An Aquarium";
		}

		public AquariumSouthAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}